[TestFixture]
public class DbOrderGatewayTest : AbstractDbGatewayTest
{
  private DbOrderGateway gateway;
  private Product pizza;
  private Product beer;

  [SetUp]
  public void SetUp()
  {
    OpenConnection();

    pizza = new Product("Pizza", "pizza", 15);
    beer = new Product("Piwo", "piwo", 2);
    ProductGateway productGateway = new InMemoryProductGateway();
    productGateway.Insert(pizza);
    productGateway.Insert(beer);

    gateway = new DbOrderGateway(connection, productGateway);
    ExecuteSql("delete from Orders");
    ExecuteSql("delete from Items");
  }

  [TearDown]
  public void TearDown()
  {
    Close();
  }

  [Test]
  public void Find()
  {
    string sql = "insert into Orders (cusId) " +
      "values ('Jacek'); select scope_identity()";
    SqlCommand command = new SqlCommand(sql, connection);
    int orderId = Convert.ToInt32(command.ExecuteScalar());
    ExecuteSql(String.Format("insert into Items (orderId, " +
      "quantity, sku) values ({0}, 1, 'pizza')", orderId));
    ExecuteSql(String.Format("insert into Items (orderId, " +
      "quantity, sku) values ({0}, 6, 'piwo')", orderId));
    Order order = gateway.Find(orderId);

    Assert.AreEqual("Jacek", order.CustomerId);
    Assert.AreEqual(2, order.ItemCount);
    Assert.AreEqual(1, order.QuantityOf(pizza));
    Assert.AreEqual(6, order.QuantityOf(beer));
  }

  [Test]
  public void Insert()
  {
    Order order = new Order("Jacek");
    order.AddItem(pizza, 1);
    order.AddItem(beer, 6);

    gateway.Insert(order);

    Assert.IsTrue(order.Id != -1);

    Order foundOrder = gateway.Find(order.Id);
    Assert.AreEqual("Jacek", foundOrder.CustomerId);
    Assert.AreEqual(2, foundOrder.ItemCount);
    Assert.AreEqual(1, foundOrder.QuantityOf(pizza));
    Assert.AreEqual(6, foundOrder.QuantityOf(beer));
  }
}
